%define name open-iscsi
%define version 2.0
%define release 742

Summary		: open-iscsi programs.
Name		: %{name}
Version		: %{version}
Release		: %{release}
Vendor		: Voltaire Inc.
Source		: open-iscsi-%{version}.tar.gz
Packager	: Erez Zilber <erezz@voltaire.com>
Provides	: open-iscsi
Group		: Storage 
License		: GPL
BuildRoot:      %{_tmppath}/%{name}


%description
This package provides open-iscsi userspace programs

%define kversion $(uname -r | sed "s/-ppc64\|-smp//")

# Set the binary rpm name accroding to the distribution type
%if "%{_vendor}" == "suse"
%if %sles_version == 10
	%define _build_name_fmt %_arch/open-iscsi-%{version}.%{release}.%_arch.rpm
%endif
%else
%if %_vendor == "redhat"
	%define _build_name_fmt %_arch/iscsi-initiator-utils-6.%{version}.%{release}.%_arch.rpm
%endif
%endif

%prep
rm -rf $RPM_BUILD_ROOT

%setup

%build

cd usr
if make; then
	echo "open-iscsi userspace code built ok"
	bail_out=0
else
	echo "Failed to build open-iscsi userspace code, cleaning up..."
	bail_out=1
fi

cd ..

if [ $bail_out = 1 ] ; then
        echo "Unable to build open-iscsi userspace"
        exit 1
fi

cd linux-iscsi
if make utils; then
	echo "linux-iscsi utils code built ok"
	bail_out=0
else
	echo "Failed to build linux-iscsi utils, cleaning up..."
	bail_out=1
fi
cd ..

if [ $bail_out = 1 ] ; then
        echo "Unable to build linux-iscsi utils"
        exit 1
fi

%install

# delete the dir where the userspace programs were built
if [ "${RPM_BUILD_ROOT}" != "/" -a -d ${RPM_BUILD_ROOT} ] ; then rm -rf ${RPM_BUILD_ROOT} ; fi

rm -rf ${RPM_BUILD_ROOT}/tmp

# Put the new open-iscsi userspace tools in our tmp dir
%define USER_PROGRAMS_LIST iscsiadm iscsid iscsistart iscsi_discovery iscsi-iname

for i in %{USER_PROGRAMS_LIST} ; do
	found_new_file=$(find ${PWD} -type f -name "*$i")
	mkdir -p ${RPM_BUILD_ROOT}/sbin
	cp $found_new_file ${RPM_BUILD_ROOT}/sbin
done

# Handle etc files (different names for each distribution)
case %{_vendor} in
        suse)
		mkdir -p ${RPM_BUILD_ROOT}/etc
		mkdir -p ${RPM_BUILD_ROOT}/etc/init.d
		cp $PWD/etc/initd/initd.suse ${RPM_BUILD_ROOT}/etc/init.d/open-iscsi
		cp $PWD/etc/iscsid.conf ${RPM_BUILD_ROOT}/etc/
		mkdir -p ${RPM_BUILD_ROOT}/etc/sysconfig
		cp $PWD/etc/sysconfig/open-iscsi ${RPM_BUILD_ROOT}/etc/sysconfig
		;;
        redhat)
		mkdir -p ${RPM_BUILD_ROOT}/etc
		mkdir -p ${RPM_BUILD_ROOT}/etc/init.d
		cp $PWD/etc/initd/initd.redhat ${RPM_BUILD_ROOT}/etc/init.d/iscsi
		mkdir -p ${RPM_BUILD_ROOT}/etc/iscsi
		cp $PWD/etc/iscsid.conf ${RPM_BUILD_ROOT}/etc/iscsi
		;;		
        *)
                echo "%{_vendor} is not supported"
                exit 1
                ;;
esac

# Put the new open-iscsi man pages in our tmp dir
%define MAN_LIST iscsi_discovery.8.gz  iscsiadm.8.gz  iscsid.8.gz

for i in %{MAN_LIST} ; do
	found_new_file=$(find ${PWD} -type f -name "*$i")
	mkdir -p ${RPM_BUILD_ROOT}/usr/share/man/man8
	cp $found_new_file ${RPM_BUILD_ROOT}/usr/share/man/man8
done

# Put misc open-iscsi files in our tmp dir
%define MISC_LIST COPYING README

for i in %{MISC_LIST} ; do
	found_new_file=$(find ${PWD} -type f -name "*$i")
	mkdir -p ${RPM_BUILD_ROOT}/usr/share/doc/packages/open-iscsi
	cp $found_new_file ${RPM_BUILD_ROOT}/usr/share/doc/packages/open-iscsi
done

# Build the file list
FILE_LIST=%{_tmppath}/open-iscsi-usr-file-list

find ${RPM_BUILD_ROOT} -type f| sed "s|${RPM_BUILD_ROOT}||" > ${FILE_LIST}

# Add directories to the file list
echo "%dir /usr/share/doc/packages/open-iscsi" >> ${FILE_LIST}

cat ${FILE_LIST}

echo %files

%clean
[ "${RPM_BUILD_ROOT}" != "/" -a -d ${RPM_BUILD_ROOT} ] && rm -rf ${RPM_BUILD_ROOT}

%pre

%post
mkdir -p /etc/iscsi

backup_dir=/usr/voltaire/backup

chmod +x /sbin/iscsi_discovery

# set the dependencies between /etc/init.d/open-iscsi & /etc/init.d/gridstack
awk '/Required-Start/{print $0 " gridstack"} !/Required-Start/{print $0}' /etc/init.d/open-iscsi > %{_tmppath}/open-iscsi
mv %{_tmppath}/open-iscsi /etc/init.d
cp /etc/init.d/gridstack $backup_dir/gridstack.saved
awk '/Required-Stop/{print $0 " iscsi"} !/Required-Stop/{print $0}' /etc/init.d/gridstack > %{_tmppath}/gridstack
mv %{_tmppath}/gridstack /etc/init.d
chmod +x /etc/init.d/open-iscsi
chmod +x /etc/init.d/gridstack
insserv /etc/init.d/gridstack
insserv /etc/init.d/open-iscsi

# create the initiatorname file if it does not exist
if [ ! -f /etc/initiatorname.iscsi ]; then
   cat << EOF >> /etc/initiatorname.iscsi
## DO NOT EDIT OR REMOVE THIS FILE!
## If you remove this file, the iSCSI daemon will not start.
## If you change the InitiatorName, existing access control lists
## may reject this initiator.  The InitiatorName must be unique
## for each iSCSI initiator.  Do NOT duplicate iSCSI InitiatorNames.
EOF
        ISSUEDATE="1996-04"
        INAME=$(/sbin/iscsi-iname -p iqn.$ISSUEDATE.voltaire.com:01)
        printf "InitiatorName=$INAME\n"  >>/etc/initiatorname.iscsi
        chmod 0600 /etc/initiatorname.iscsi
fi

# if the initiatorname file is not in its new location, add a link to it
if ! [ -e /etc/iscsi/initiatorname.iscsi ] ; then
	ln -snf /etc/initiatorname.iscsi /etc/iscsi/initiatorname.iscsi
fi
 
exit 0

%preun

# remove the dependencies between /etc/init.d/open-iscsi & /etc/init.d/gridstack
insserv -r /etc/init.d/open-iscsi
insserv -r /etc/init.d/gridstack

%postun

backup_dir=/usr/voltaire/backup

# restore the original gridstack script
mv $backup_dir/gridstack.saved /etc/init.d/gridstack

%files -f %{_tmppath}/open-iscsi-usr-file-list

